<?php
session_start();
if (isset($_SESSION['user_id'])) {
    header("Location: ../admin/dashboard.php");
    exit;
}

require '../../config/database.php';
$error = '';

if ($_POST) {
    $login = trim($_POST['login']);
    $password = $_POST['password'];

    if (empty($login) || empty($password)) {
        $error = "Fill all fields!";
    } else {
        // email নাকি phone?
        $field = filter_var($login, FILTER_VALIDATE_EMAIL) ? 'email' : 'phone';
        $stmt = $pdo->prepare("SELECT id, password FROM users WHERE $field = ?");
        $stmt->execute([$login]);
        $user = $stmt->fetch();

        if ($user && password_verify($password, $user['password'])) {
            $_SESSION['user_id'] = $user['id'];
            header("Location: ../admin/dashboard.php");
            exit;
        } else {
            $error = "Wrong email/phone or password!";
        }
    }
}
?>

<!DOCTYPE html>
<html class="h-full bg-gradient-to-br from-blue-50 to-purple-50">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login • ProCMS</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/npm/daisyui@4.12.10/dist/full.min.css" rel="stylesheet">
</head>
<body class="h-full flex items-center justify-center p-4">

<div class="w-full max-w-md bg-white/90 backdrop-blur-xl rounded-3xl shadow-2xl p-10">
    <div class="text-center mb-10">
        <h1 class="text-5xl font-black bg-gradient-to-r from-blue-600 to-purple-600 bg-clip-text text-transparent">ProCMS</h1>
        <p class="mt-4 text-gray-600">Sign in to continue</p>
    </div>

    <?php if($error): ?>
        <div class="alert alert-error mb-6"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="POST" class="space-y-6">
        <input type="text" name="login" placeholder="Email or Phone" class="input input-lg w-full rounded-2xl" required autofocus>
        <input type="password" name="password" placeholder="Password" class="input input-lg w-full rounded-2xl" required>
        <button type="submit class="btn btn-primary btn-lg w-full rounded-2xl">Login</button>
    </form>

    <p class="text-center mt-8 text-sm text-gray-600">
        No account? <a href="register.php" class="text-blue-600 font-bold">Register here</a>
    </p>
</div>

</body>
</html>