<?php 
require 'header.php'; 
require 'sidebar.php'; 

$id = $_GET['id'] ?? null;
$post = null;
$featured_image = '';

if ($id) {
    $stmt = $pdo->prepare("SELECT * FROM posts WHERE id = ?");
    $stmt->execute([$id]);
    $post = $stmt->fetch(PDO::FETCH_ASSOC);
    $featured_image = $post['featured_image'] ?? '';
}

$categories = $pdo->query("SELECT * FROM categories ORDER BY name")->fetchAll();

if ($_POST) {
    $title       = trim($_POST['title'] ?? '');
    $content     = $_POST['content'] ?? '';
    $category_id = (int)($_POST['category_id'] ?? 1);
    $old_image   = $_POST['old_image'] ?? '';

    // Featured image upload
    if (!empty($_FILES['featured_image']['name'])) {
        $file = $_FILES['featured_image'];
        $ext = pathinfo($file['name'], PATHINFO_EXTENSION);
        $name = 'thumb_' . time() . '.' . $ext;
        $path = '../assets/uploads/' . $name;
        if (move_uploaded_file($file['tmp_name'], $path)) {
            $featured_image = '../assets/uploads/' . $name;
            if ($old_image && file_exists($old_image)) @unlink($old_image);
        }
    } else {
        $featured_image = $old_image;
    }

    if (empty($title)) {
        $error = "Title is required!";
    } else {
        if ($id) {
            $pdo->prepare("UPDATE posts SET title=?, content=?, category_id=?, featured_image=? WHERE id=?")
                ->execute([$title, $content, $category_id, $featured_image, $id]);
        } else {
            $pdo->prepare("INSERT INTO posts (title, content, category_id, featured_image) VALUES (?,?,?,?)")
                ->execute([$title, $content, $category_id, $featured_image]);
        }
        echo "<script>alert('Saved!'); location='posts.php';</script>";
        exit;
    }
}
?>

<div class="flex-1 p-8">
    <div class="max-w-4xl mx-auto bg-white rounded-2xl shadow-2xl p-10">

        <h1 class="text-4xl font-bold mb-8 text-center text-indigo-600">
            <?= $id ? 'Edit Post' : 'Add New Post' ?>
        </h1>

        <?php if (!empty($error)): ?>
            <div class="alert alert-error mb-6"><?= $error ?></div>
        <?php endif; ?>

        <form method="POST" enctype="multipart/form-data" class="space-y-8">

            <input type="text" name="title" value="<?= htmlspecialchars($post['title'] ?? '') ?>" 
                   placeholder="Post Title" required class="input input-bordered input-lg w-full text-2xl" autofocus>

            <select name="category_id" class="select select-bordered w-full" required>
                <?php foreach($categories as $c): ?>
                    <option value="<?= $c['id'] ?>" <?= ($post['category_id'] ?? 1) == $c['id'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($c['name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>

            <?php if ($featured_image): ?>
                <div class="text-center mb-4">
                    <img src="<?= $featured_image ?>" class="h-64 rounded-xl shadow-lg inline-block">
                    <p class="text-sm text-gray-500 mt-2">Current Featured Image</p>
                </div>
            <?php endif; ?>

            <input type="file" name="featured_image" accept="image/*" class="file-input file-input-bordered w-full">
            <input type="hidden" name="old_image" value="<?= $featured_image ?>">

            <div id="editor" class="min-h-96 border rounded-xl">
                <?= $post['content'] ?? '' ?>
            </div>
            <textarea name="content" id="hidden-content" class="hidden"></textarea>

            <div class="text-center mt-10">
                <button type="submit" class="btn btn-success btn-lg px-16">
                    <?= $id ? 'Update' : 'Publish' ?> Post
                </button>
            </div>
        </form>
    </div>
</div>

<link href="https://cdn.jsdelivr.net/npm/quill@2.0.2/dist/quill.snow.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/quill@2.0.2/dist/quill.js"></script>

<script>
    const quill = new Quill('#editor', { theme: 'snow' });

    quill.getModule('toolbar').addHandler('image', () => {
        const input = document.createElement('input');
        input.type = 'file';
        input.accept = 'image/*';
        input.click();
        input.onchange = () => {
            const file = input.files[0];
            const fd = new FormData();
            fd.append('file', file);
            fetch('upload.php', { method: 'POST', body: fd })
                .then(r => r.json())
                .then(d => {
                    if (d.location) {
                        const r = quill.getSelection(true);
                        quill.insertEmbed(r.index, 'image', d.location);
                    }
                });
        };
    });

    document.querySelector('form').onsubmit = () => {
        document.getElementById('hidden-content').value = quill.root.innerHTML;
    };
</script>

<?php require 'footer.php'; ?>