<?php 
include 'header.php'; 
include 'sidebar.php'; 
?>
<div class="flex-1 p-10">
    <h1 class="text-4xl font-bold mb-8">Welcome back, <?= htmlspecialchars($_SESSION['username']) ?>!</h1>
    
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-10">
        <div class="stat shadow-lg bg-base-200 rounded-xl p-6">
            <div class="stat-title text-lg">Total Posts</div>
            <div class="stat-value text-primary text-4xl">
                <?= $pdo->query("SELECT COUNT(*) FROM posts")->fetchColumn() ?>
            </div>
        </div>
        
        <div class="stat shadow-lg bg-base-200 rounded-xl p-6">
            <div class="stat-title text-lg">Total Users</div>
            <div class="stat-value text-secondary text-4xl">
                <?= $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn() ?>
            </div>
        </div>
        
        <div class="stat shadow-lg bg-base-200 rounded-xl p-6">
            <div class="stat-title text-lg">Active Theme</div>
            <div class="stat-value text-info text-3xl">Default</div>
        </div>
        
        <div class="stat shadow-lg bg-base-200 rounded-xl p-6">
            <div class="stat-title text-lg">Today</div>
            <div class="stat-value text-accent text-3xl"><?= date('d M Y') ?></div>
        </div>
    </div>

    <div class="alert alert-info shadow-lg">
        <div>
            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" class="stroke-current flex-shrink-0 w-6 h-6"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
            <span>Your ProCMS is running perfectly! Start creating content.</span>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>