<?php
session_start();
if (!isset($_SESSION['user_id'])) { header("Location: login.php"); exit(); }
require '../config/database.php';
?>
<!DOCTYPE html>
<html lang="en" data-theme="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ProCMS - Admin</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/npm/daisyui@4.12.10/dist/full.min.css" rel="stylesheet">
    <script src="https://kit.fontawesome.com/7b9b4a83b3.js" crossorigin="anonymous"></script>
</head>
<body class="bg-gray-50">

<!-- Top Bar -->
<nav class="bg-white border-b border-gray-200 fixed top-0 left-0 right-0 z-50 shadow-sm">
    <div class="px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center h-16">
            <div class="flex items-center">
                <button id="menuBtn" class="p-2 rounded-md text-gray-600 hover:bg-gray-100 lg:hidden">
                    <i class="fas fa-bars text-xl"></i>
                </button>
                <h1 class="ml-4 text-2xl font-bold text-gray-800">ProCMS</h1>
            </div>
            <div class="flex items-center space-x-6">
                <span class="text-gray-700">Hi, <?= htmlspecialchars($_SESSION['username']) ?></span>
                <a href="logout.php" class="text-red-600 hover:text-red-700">
                    <i class="fas fa-sign-out-alt"></i>
                </a>
            </div>
        </div>
    </div>
</nav>

<div class="flex pt-16">