<?php
require_once('../config.php');

if (INSTALLED === true) {
    header('Location: ../admin/dashboard.php');
    exit;
}

$error = '';
$db_info = [];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $db_info = $_POST;
    $server = trim($_POST['db_server']);
    $username = trim($_POST['db_username']);
    $password = $_POST['db_password']; // password can be empty
    $dbname = trim($_POST['db_name']);

    // 1. Attempt to connect to MySQL server without selecting a DB
    $pdo_no_db = connect_db($server, $username, $password);

    if ($pdo_no_db) {
        try {
            // 2. Create the Database if it doesn't exist
            $pdo_no_db->exec("CREATE DATABASE IF NOT EXISTS `$dbname` COLLATE utf8mb4_general_ci;");

            // 3. Connect to the newly created/existing database
            $pdo = connect_db($server, $username, $password, $dbname);

            if ($pdo) {
                // 4. Define SQL to create necessary tables (e.g., users, pages, settings)
                $sql = "
                CREATE TABLE IF NOT EXISTS `users` (
                    `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
                    `username` VARCHAR(50) NOT NULL UNIQUE,
                    `email` VARCHAR(100) NOT NULL UNIQUE,
                    `password` CHAR(60) NOT NULL,
                    `role` ENUM('admin', 'editor', 'user') NOT NULL DEFAULT 'user',
                    `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
                    PRIMARY KEY (`id`)
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

                CREATE TABLE IF NOT EXISTS `pages` (
                    `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
                    `title` VARCHAR(255) NOT NULL,
                    `slug` VARCHAR(255) NOT NULL UNIQUE,
                    `content` TEXT,
                    `status` ENUM('published', 'draft') NOT NULL DEFAULT 'draft',
                    PRIMARY KEY (`id`)
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
                ";

                // 5. Execute table creation SQL
                $pdo->exec($sql);

                // 6. Update config.php with new database details and set INSTALLED to true
                $config_content = file_get_contents('../config.php');
                $config_content = str_replace(
                    [
                        "define('DB_SERVER', 'localhost');",
                        "define('DB_USERNAME', 'root');",
                        "define('DB_PASSWORD', '');",
                        "define('DB_NAME', 'admin_panel_db');",
                        "define('INSTALLED', false);"
                    ],
                    [
                        "define('DB_SERVER', '$server');",
                        "define('DB_USERNAME', '$username');",
                        "define('DB_PASSWORD', '$password');",
                        "define('DB_NAME', '$dbname');",
                        "define('INSTALLED', false);" // Keep false for now, step 3 will set it to true
                    ],
                    $config_content
                );
                file_put_contents('../config.php', $config_content);


                // 7. Success! Redirect to Step 3
                header('Location: step3_admin_info.php');
                exit;

            } else {
                $error = 'Failed to connect to the new database. Check DB Name.';
            }

        } catch (PDOException $e) {
            // For security, do not display $e->getMessage() in production
            $error = "Database Error: Could not create database or tables. Please check permissions. Error: " . $e->getMessage();
        }
    } else {
        $error = 'Failed to connect to MySQL server. Check server, username, and password.';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Step 2: Database Setup</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container my-5">
        <div class="card shadow-lg">
            <div class="card-header bg-primary text-white">
                <h2>Admin Panel Installation Wizard</h2>
            </div>
            <div class="card-body">
                <h3>Step 2: Database Setup</h3>
                <?php if ($error): ?>
                    <div class="alert alert-danger"><?= $error ?></div>
                <?php endif; ?>
                <form method="POST">
                    <div class="mb-3">
                        <label for="db_server" class="form-label">Database Server</label>
                        <input type="text" class="form-control" id="db_server" name="db_server" value="<?= $db_info['db_server'] ?? 'localhost' ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="db_username" class="form-label">Database Username</label>
                        <input type="text" class="form-control" id="db_username" name="db_username" value="<?= $db_info['db_username'] ?? 'root' ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="db_password" class="form-label">Database Password</label>
                        <input type="password" class="form-control" id="db_password" name="db_password" value="<?= $db_info['db_password'] ?? '' ?>">
                        <small class="form-text text-muted">Leave blank if no password is set (like default XAMPP).</small>
                    </div>
                    <div class="mb-3">
                        <label for="db_name" class="form-label">Database Name</label>
                        <input type="text" class="form-control" id="db_name" name="db_name" value="<?= $db_info['db_name'] ?? 'admin_panel_db' ?>" required>
                    </div>
                    <button type="submit" class="btn btn-success btn-lg">Setup Database & Tables</button>
                </form>
            </div>
            <div class="card-footer text-muted">
                Current Step: Database Setup
            </div>
        </div>
    </div>
</body>
</html>