<?php
require_once('../config.php');

// Redirect to dashboard if already installed
if (INSTALLED === true) {
    header('Location: ../admin/dashboard.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Step 1: Welcome</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container my-5">
        <div class="card shadow-lg">
            <div class="card-header bg-primary text-white">
                <h2>Admin Panel Installation Wizard</h2>
            </div>
            <div class="card-body">
                <h3>Step 1: Welcome!</h3>
                <p>Welcome to the setup process for your new Admin Panel. This wizard will guide you through connecting your database and setting up your first administrator account.</p>
                
                <p class="mt-4">
                    <strong>Pre-Requisites Check:</strong><br>
                    - PHP Version (7.4+ Recommended): **OK**<br>
                    - MySQL/MariaDB Access: **Required in next step**<br>
                    - Write permission on <code>config.php</code>: **Required for auto-setup**
                </p>

                <a href="step2_database.php" class="btn btn-success btn-lg mt-3">Start Installation</a>
            </div>
            <div class="card-footer text-muted">
                Current Step: Welcome
            </div>
        </div>
    </div>
</body>
</html>