<?php
include('includes/header.php'); 

// Check for Delete Action
$message = '';

if (isset($_GET['action']) && $_GET['action'] == 'delete' && isset($_GET['id'])) {
    $user_id_to_delete = (int)$_GET['id'];
    
    // Call the function from functions.php
    $result = delete_user($user_id_to_delete);
    
    $parts = explode(':', $result, 2);
    $type = trim($parts[0]);
    $msg = trim($parts[1]);
    
    // Set message based on the result
    if ($type == 'success') {
        $message = ['type' => 'success', 'text' => $msg];
        // Redirect to clean URL to prevent re-submission on refresh
        header('Location: users.php?status=success&msg=' . urlencode($msg));
        exit;
    } else {
        $message = ['type' => 'danger', 'text' => $msg];
    }
}

// Display status message if redirected after successful action
if (isset($_GET['status']) && $_GET['status'] == 'success' && isset($_GET['msg'])) {
    $message = ['type' => 'success', 'text' => htmlspecialchars($_GET['msg'])];
}


// --- READ (Display User List) ---
$pdo = get_pdo();
$users = [];
if ($pdo) {
    try {
        $stmt = $pdo->prepare("SELECT id, username, email, role, created_at FROM users ORDER BY created_at DESC");
        $stmt->execute();
        $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        $message = ['type' => 'danger', 'text' => 'Error fetching users: ' . $e->getMessage()];
    }
}
?>

<h1 class="mb-4"><i class="fas fa-users me-2"></i> User Management</h1>
<hr>

<?php if (!empty($message)): ?>
    <div class="alert alert-<?= $message['type'] ?> alert-dismissible fade show" role="alert">
        <?= $message['text'] ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<div class="card shadow mb-4">
    <div class="card-header py-3 d-flex justify-content-between align-items-center">
        <h6 class="m-0 font-weight-bold text-primary">All Users</h6>
        <a href="users_add.php" class="btn btn-sm btn-primary"><i class="fas fa-plus me-1"></i> Add New User</a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <?php if ($users): ?>
                <table class="table table-bordered table-striped" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Username</th>
                            <th>Email</th>
                            <th>Role</th>
                            <th>Created At</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($users as $user): ?>
                        <tr>
                            <td><?= htmlspecialchars($user['id']) ?></td>
                            <td><?= htmlspecialchars($user['username']) ?></td>
                            <td><?= htmlspecialchars($user['email']) ?></td>
                            <td><span class="badge bg-<?= $user['role'] == 'admin' ? 'danger' : 'success' ?>"><?= ucfirst(htmlspecialchars($user['role'])) ?></span></td>
                            <td><?= date('Y-m-d H:i', strtotime($user['created_at'])) ?></td>
                            <td>
                                <a href="users_edit.php?id=<?= $user['id'] ?>" class="btn btn-sm btn-info me-2" title="Edit"><i class="fas fa-edit"></i></a>
                                
                                <a href="users.php?action=delete&id=<?= $user['id'] ?>" 
                                   class="btn btn-sm btn-danger" 
                                   title="Delete"
                                   onclick="return confirm('Are you sure you want to delete user: <?= htmlspecialchars($user['username']) ?>?');">
                                    <i class="fas fa-trash"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <div class="alert alert-info">No users found in the database.</div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php include('includes/footer.php'); ?>