<?php
include('includes/header.php'); 

$error = '';
$success = '';

// Check if the form is submitted
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $title = trim($_POST['title']);
    $slug = trim($_POST['slug']);
    $content = $_POST['content'];
    $status = $_POST['status'];

    // --- Validation ---
    if (empty($title) || empty($slug)) {
        $error = 'Title and Slug fields are required.';
    } else {
        // --- Database Insertion ---
        $pdo = get_pdo();

        if ($pdo) {
            try {
                // 1. Check if slug already exists
                $check_stmt = $pdo->prepare("SELECT COUNT(*) FROM pages WHERE slug = ?");
                $check_stmt->execute([$slug]);
                
                if ($check_stmt->fetchColumn() > 0) {
                    $error = 'The Slug already exists. Please choose a different one.';
                } else {
                    // 2. Insert the new page
                    $stmt = $pdo->prepare("INSERT INTO pages (title, slug, content, status) VALUES (?, ?, ?, ?)");
                    $stmt->execute([$title, $slug, $content, $status]);
                    
                    $success = "Page **" . htmlspecialchars($title) . "** created successfully!";
                    
                    // Optional: Clear POST data after success
                    $_POST = array(); 
                }

            } catch (PDOException $e) {
                $error = 'Database error: Could not add page. ' . $e->getMessage();
            }
        } else {
            $error = 'Database connection failed.';
        }
    }
}
?>
<h1 class="mb-4"><i class="fas fa-plus me-2"></i> Add New Page</h1>
<hr>

<?php if ($success): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?= $success ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<?php if ($error): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?= $error ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">New Page Details</h6>
    </div>
    <div class="card-body">
        <form method="POST">
            <div class="mb-3">
                <label for="title" class="form-label">Page Title <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="title" name="title" 
                       value="<?= htmlspecialchars($_POST['title'] ?? '') ?>" required>
            </div>
            
            <div class="mb-3">
                <label for="slug" class="form-label">Page Slug (URL) <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="slug" name="slug" 
                       value="<?= htmlspecialchars($_POST['slug'] ?? '') ?>" required>
                <small class="text-muted">Example: about-us. Only lowercase letters, numbers, and hyphens.</small>
            </div>

            <div class="mb-3">
                <label for="content" class="form-label">Content</label>
                <textarea class="form-control" id="content" name="content" rows="10"><?= htmlspecialchars($_POST['content'] ?? '') ?></textarea>
            </div>

            <div class="mb-3">
                <label for="status" class="form-label">Status</label>
                <select class="form-select" id="status" name="status">
                    <option value="draft" <?= (($_POST['status'] ?? '') == 'draft') ? 'selected' : '' ?>>Draft</option>
                    <option value="published" <?= (($_POST['status'] ?? '') == 'published') ? 'selected' : '' ?>>Published</option>
                </select>
            </div>

            <div class="d-flex justify-content-between">
                <a href="pages.php" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-1"></i> Back to Page List
                </a>
                <button type="submit" class="btn btn-success">
                    <i class="fas fa-save me-1"></i> Save Page
                </button>
            </div>
        </form>
    </div>
</div>

<script>
    // Simple JavaScript to auto-generate slug from title
    document.addEventListener('DOMContentLoaded', function() {
        const titleInput = document.getElementById('title');
        const slugInput = document.getElementById('slug');

        titleInput.addEventListener('input', function() {
            if (slugInput.value === '' || slugInput.getAttribute('data-manual') !== 'true') {
                const title = this.value.toLowerCase().trim();
                const slug = title
                    .replace(/[^a-z0-9\s-]/g, '') // Remove non-alphanumeric characters except space/hyphen
                    .replace(/\s+/g, '-')        // Replace spaces with hyphens
                    .replace(/-+/g, '-');        // Replace multiple hyphens with single hyphen
                slugInput.value = slug;
            }
        });

        // Add a flag if user manually changes the slug
        slugInput.addEventListener('input', function() {
            this.setAttribute('data-manual', 'true');
        });
    });
</script>

<?php include('includes/footer.php'); ?>