<?php
include('includes/header.php'); 

$error = '';
$success = '';

// Check if the form is submitted
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = trim($_POST['name']);
    $location = trim($_POST['location']);

    // --- Validation ---
    if (empty($name) || empty($location)) {
        $error = 'Menu Name and Location Slug are required.';
    } else {
        $pdo = get_pdo();

        if ($pdo) {
            try {
                // 1. Check if location slug already exists
                $check_stmt = $pdo->prepare("SELECT COUNT(*) FROM menus WHERE location = ?");
                $check_stmt->execute([$location]);
                
                if ($check_stmt->fetchColumn() > 0) {
                    $error = 'The Location Slug already exists. Please choose a different one.';
                } else {
                    // 2. Insert the new menu
                    $stmt = $pdo->prepare("INSERT INTO menus (name, location) VALUES (?, ?)");
                    $stmt->execute([$name, $location]);
                    
                    $success = "Menu **" . htmlspecialchars($name) . "** created successfully! Now you can add items.";
                    
                    // Optional: Clear POST data after success
                    $_POST = array(); 
                }

            } catch (PDOException $e) {
                $error = 'Database error: Could not add menu. ' . $e->getMessage();
            }
        } else {
            $error = 'Database connection failed.';
        }
    }
}
?>
<h1 class="mb-4"><i class="fas fa-plus me-2"></i> Create New Menu</h1>
<hr>

<?php if ($success): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?= $success ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<?php if ($error): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?= $error ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Menu Information</h6>
    </div>
    <div class="card-body">
        <form method="POST">
            <div class="mb-3">
                <label for="name" class="form-label">Menu Name <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="name" name="name" 
                       value="<?= htmlspecialchars($_POST['name'] ?? '') ?>" required>
            </div>
            
            <div class="mb-3">
                <label for="location" class="form-label">Location Slug <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="location" name="location" 
                       value="<?= htmlspecialchars($_POST['location'] ?? '') ?>" required>
                <small class="text-muted">Used by developers to call the menu (e.g., primary-nav, footer-links).</small>
            </div>

            <div class="d-flex justify-content-between">
                <a href="menus.php" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-1"></i> Back to Menus
                </a>
                <button type="submit" class="btn btn-success">
                    <i class="fas fa-save me-1"></i> Create Menu
                </button>
            </div>
        </form>
    </div>
</div>

<?php include('includes/footer.php'); ?>