<?php
include('includes/header.php'); 

$message = '';

// --- Delete Menu Action ---
if (isset($_GET['action']) && $_GET['action'] == 'delete' && isset($_GET['id'])) {
    $menu_id_to_delete = (int)$_GET['id'];
    $pdo = get_pdo();
    
    if ($pdo) {
        try {
            // Start transaction
            $pdo->beginTransaction();

            // 1. Delete all menu items belonging to this menu
            $pdo->prepare("DELETE FROM menu_items WHERE menu_id = ?")->execute([$menu_id_to_delete]);

            // 2. Delete the menu itself
            $pdo->prepare("DELETE FROM menus WHERE id = ?")->execute([$menu_id_to_delete]);

            $pdo->commit();
            header('Location: menus.php?status=success&msg=' . urlencode('Menu and all its items deleted successfully.'));
            exit;

        } catch (PDOException $e) {
            $pdo->rollBack();
            $message = ['type' => 'danger', 'text' => 'Database error during deletion: ' . $e->getMessage()];
        }
    } else {
        $message = ['type' => 'danger', 'text' => 'Database connection failed.'];
    }
}

// Display status message if redirected after action
if (isset($_GET['status']) && isset($_GET['msg'])) {
    $message = ['type' => $_GET['status'], 'text' => htmlspecialchars($_GET['msg'])];
}


// --- READ (Display Menu List) ---
$pdo = get_pdo();
$menus = [];
if ($pdo) {
    try {
        $stmt = $pdo->prepare("SELECT id, name, location FROM menus ORDER BY id ASC");
        $stmt->execute();
        $menus = $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        $message = ['type' => 'danger', 'text' => 'Error fetching menus: ' . $e->getMessage()];
    }
}
?>

<h1 class="mb-4"><i class="fas fa-bars me-2"></i> Menu Management</h1>
<hr>

<?php if (!empty($message)): ?>
    <div class="alert alert-<?= $message['type'] ?> alert-dismissible fade show" role="alert">
        <?= $message['text'] ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<div class="card shadow mb-4">
    <div class="card-header py-3 d-flex justify-content-between align-items-center">
        <h6 class="m-0 font-weight-bold text-primary">Website Menus</h6>
        <a href="menus_add.php" class="btn btn-sm btn-primary"><i class="fas fa-plus me-1"></i> Create New Menu</a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <?php if ($menus): ?>
                <table class="table table-bordered table-striped" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Menu Name</th>
                            <th>Location Slug</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($menus as $menu): ?>
                        <tr>
                            <td><?= htmlspecialchars($menu['id']) ?></td>
                            <td><?= htmlspecialchars($menu['name']) ?></td>
                            <td><code><?= htmlspecialchars($menu['location']) ?></code></td>
                            <td>
                                <a href="menu_items.php?menu_id=<?= $menu['id'] ?>" class="btn btn-sm btn-success me-2" title="Manage Items"><i class="fas fa-list-ul me-1"></i> Manage Items</a>
                                
                                <a href="menus_edit.php?id=<?= $menu['id'] ?>" class="btn btn-sm btn-info me-2" title="Edit Menu Info"><i class="fas fa-edit"></i></a>
                                
                                <a href="menus.php?action=delete&id=<?= $menu['id'] ?>" 
                                   class="btn btn-sm btn-danger" 
                                   title="Delete Menu"
                                   onclick="return confirm('WARNING: Are you sure you want to delete the entire menu: <?= htmlspecialchars($menu['name']) ?> and all its items?');">
                                    <i class="fas fa-trash"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <div class="alert alert-info">No menus have been created yet.</div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php include('includes/footer.php'); ?>