<?php
ob_start(); 
session_start();
require_once('../config.php');
require_once('functions.php');
check_login();

$current_page = basename($_SERVER['PHP_SELF'], '.php');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - <?= ucwords(str_replace('-', ' ', $current_page)) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        /* ------------------- Custom Sidebar Styles ------------------- */
        .sidebar {
            height: 100vh;
            width: 250px;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1050; 
            background-color: #343a40; 
            padding-top: 56px;
            transition: all 0.3s;
        }
        .sidebar .nav-link { color: #f8f9fa; }
        .sidebar .nav-link.active { background-color: #0d6efd; color: white; }
        
        /* Main Content Adjustment */
        .main-content { 
            margin-left: 250px; 
            padding: 20px; 
            transition: margin-left 0.3s;
        }

        /* Toggled/Collapsed State */
        .sidebar.collapsed {
            margin-left: -250px; 
        }
        /* When sidebar is collapsed, main content expands */
        .main-content.expanded {
            margin-left: 0; 
        }

        /* Navbar: Ensure the toggle button is visible */
        .navbar-toggler-custom {
            /* This ensures the button is visible on large screens (desktop) */
            display: inline-block; 
        }
        
        /* Responsive adjustment for smaller screens (Mobile) */
        @media (max-width: 991.98px) {
            .sidebar {
                margin-left: -250px; /* Always start hidden on mobile */
            }
            .main-content {
                margin-left: 0; /* Always full width on mobile */
            }
            .sidebar.collapsed {
                margin-left: 0; /* Show when toggled on mobile */
            }
            /* Hide the custom desktop toggle button on small screens */
            #sidebarToggle {
                display: none !important; 
            }
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark fixed-top">
        <div class="container-fluid">
            <button class="btn btn-outline-light me-3 navbar-toggler-custom" id="sidebarToggle"> 
                <i class="fas fa-bars"></i>
            </button>
            
            <a class="navbar-brand" href="dashboard.php">Admin Panel</a>
            
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#topNavbarCollapse" aria-controls="topNavbarCollapse" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="topNavbarCollapse">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fas fa-user-circle me-1"></i> Welcome, <?= htmlspecialchars($_SESSION['username']) ?> 
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                            <li><a class="dropdown-item" href="profile.php">Edit Profile</a></li>
                            <li><a class="dropdown-item" href="password_change.php">Change Password</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="index.php?action=logout">Logout</a></li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <div class="sidebar" id="sidebar">
        <ul class="nav flex-column pt-3">
            <li class="nav-item">
                <a class="nav-link <?= $current_page == 'dashboard' ? 'active' : '' ?>" href="dashboard.php"><i class="fas fa-tachometer-alt me-2"></i> Dashboard</a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= $current_page == 'media' ? 'active' : '' ?>" href="media.php"><i class="fas fa-fw fa-photo-video"></i> Media</a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= $current_page == 'users' ? 'active' : '' ?>" href="users.php"><i class="fas fa-users me-2"></i> Users</a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= $current_page == 'pages' ? 'active' : '' ?>" href="pages.php"><i class="fas fa-file-alt me-2"></i> Pages</a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= $current_page == 'menus' ? 'active' : '' ?>" href="menus.php"><i class="fas fa-bars me-2"></i> Menus</a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= $current_page == 'tools' ? 'active' : '' ?>" href="tools.php"><i class="fas fa-fw fa-tools"></i> Tools</a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= $current_page == 'settings' ? 'active' : '' ?>" href="settings.php"><i class="fas fa-fw fa-cogs"></i> Settings</a>
            </li>
        </ul>
    </div>

    <div class="main-content" id="main-content">
        <div style="margin-top: 60px;"></div>